imports System.Windows.Forms

' Contient l'tat du moteur.
public enum EngineState
    engineAlive
    engineDead
end enum

' Contient la source musicale.
public enum MusicMedia
    musicCD
    musicTape
	musicRadio
end enum

'La classe de base abstraite de la hirarchie.
public MustInherit class Car
    ' Donnes d'tat.
    Protected mPetName As String
    Protected mCurrSpeed As Short
    Protected mMaxSpeed As Short
	protected egnState as EngineState

    ' Constructeurs.
	public Sub New()
        egnState = EngineState.engineAlive
    end sub

    Public Sub New(ByVal name As String, ByVal max As Short, ByVal curr As Short)
        egnState = EngineState.engineAlive
        petName = name
        mMaxSpeed = max
        mCurrSpeed = curr
    End Sub

    ' Proprits.
    Public Overridable Property PetName() As String
        Get
            Return mPetName
        End Get

        Set(ByVal Value As String)
            mPetName = Value
        End Set
    End Property
    Public Overridable Property CurrSpeed() As Short
        Get
            Return mCurrSpeed
        End Get

        Set(ByVal Value As Short)
            mCurrSpeed = Value
        End Set
    End Property

    Public Overridable ReadOnly Property MaxSpeed() As Short
        Get
            Return mMaxSpeed
        End Get
    End Property

    Public Overridable ReadOnly Property EngineState() As EngineState
        Get
            Return egnState
        End Get
    End Property

    ' Membres abstraits.
    Public MustOverride Sub TurboBoost()

    ' Mthode hrite.
    Public Overridable Sub TurnOnRadio(ByVal state As Boolean, ByVal mm As MusicMedia)
        If (state) Then
            MessageBox.Show("Diffusion en cours depuis " & mm.ToString())
        Else
            MessageBox.Show("Autoradio au repos...")
        End If
    End Sub
End Class